classdef MatrixComparison < handle
    %MATRIXCOMPARISON Compare two different AdjacencyMatrix objects
    %   Detailed explanation goes here
    
    properties (Access = protected)
        adjMat1
        adjMat2
        
        name1 = adjMat1;
        name2 = adjMat2;
        A1
        A2
        
        
        S
        SrowLabels
        ScolumnLabels
        
        similarityMethod = 'weightSimilarity';
        generateMatrix = @weightSimilarityComp
        direction = 'both'
        combineMethod = @intersect;
        groups
    end
    
    methods (Access = protected)
        weightSimilarityComp(obj)
    end
    
    methods (Access = public)
        function obj = MatrixComparison(adjMat1,adjMat2,varargin)
            
            
            % Read the parameters
            for i = 1:2:numel(varargin)
                switch varargin{i}
                    case 'similarityMethod'
                        obj.similarityMethod = varargin{i+1};
                        switch varargin{i+1}
                            case 'weightSimilarity'
                                obj.generateMatrix = @weightSimilarityComp;
                        end                
                    case 'groups'
                        obj.groups = varargin{i+1};
                    case 'name1'
                        obj.name1 = varargin{i+1};
                    case 'name2'
                        obj.name2 = varargin{i+1};
                    case 'combineMethod'
                        obj.combineMethod = eval(['@' varargin{i+1}]);
                end
            end
            
            
            % Form the comparison matrix            
            [A1 labels1] = getSquareMatrix(adjMat1);
            [A2 labels2] = getSquareMatrix(adjMat2);
            combLabels = obj.combineMethod(labels1,labels2);
            obj.SrowLabels = intersect(combLabels,labels1);
            obj.ScolumnLabels = intersect(combLabels,labels2);
            obj.adjMat1 = adjMat1;
            obj.adjMat2 = adjMat2;
            

            
            obj.generateMatrix(obj)

        end
        
        function disp(obj)
            fprintf('MatrixComparison object\n');
            fprintf('Comparing %s to %s\n',obj.name1,obj.name2);
            fprintf('%u rows, %u columns in similarity matrix\n',numel(obj.SrowLabels),numel(obj.ScolumnLabels));
        end
        
        val = subsref(A,S)
        showMostSimilarPairs(obj,N)
        showHistogram(obj,N)
        sameNodeSimilarity(obj)
    end
    
end

